#version 330
#extension GL_EXT_gpu_shader4 : enable
//OrbitTrap MandelbrotMod01.fsh  by  cheasify
//https://www.shadertoy.com/view/ttfcRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//fast and ez
vec3 color(float x){
	x=sin(x);//so it loops nicely
    //x=abs(sin(x));//limits colors 
    //bezier, you can rearange the functions for different color combos but this one is best
    float r=(1.0-x)*(1.0-x);
    float g=x*x;
    float b=2.0*(1.0-x)*x;
    return vec3(r,g,b);
}

float orbitMeasure(vec2 point){
    //point 
	//return distance(point,vec2(-1,0));
    
    //shifted line 
    //vec2 s=vec2(-2,0);//offset
    //vec2 dir=vec2(cos(iTime),sin(iTime));//direction of line
    //float d=dot(point-s,dir)/length(dir);
    //return sqrt(length(point-s)*length(point-s)-d*d);
    
    //shifted circle
    //note the point is just a 0 radius circle 
    vec2 c=2.1*vec2(cos(iTime)-.25,sin(iTime));// this looks cool
    //vec2 c=vec2(1,0);
    float r=1.4;
    return abs(r-length(point-c));
    
    //any function that takes in a 2d vector and outputs a scalar, preferably positive scalars 
}

//(x+yi)^2=(x+yi)(x+yi)=x^2+(yi)^2+2xyi since i^2=-1 then =x^2-y^2+2xyi 
vec2 square(vec2 n){
	return vec2(n.x*n.x-n.y*n.y,2.0*n.x*n.y);
}

//const vec2 center=vec2( -0.743643887037158704752191506114774, 0.131825904205311970493132056385139);
const vec2 center= vec2(-1,0);
const int maxiter=100;

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv=1.5*((2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y);
    //uv/=exp2(iTime);
    uv+=center;
    
    float mini=1e20f;
    vec2 value=vec2(0);
    for(int i=0;i<maxiter;i++){
        value=square(value)+uv;
    	mini=min(orbitMeasure(value),mini);   
    }
   	gl_FragColor=vec4(color(length(mini+2.5)*2.5)*.8,1);
}